# Risanje policirkulantov
# Tomaz Pisanski, junij, 2011

from tkinter import *
from math import *


def risikrov(vrts,arcs,d,k = 1,r = 2):
    window = Tk()
    canvas = Canvas(window, width=800, height=600)
    canvas.pack()
    for v in vrts.keys():
        (x,y) = vrts[v]
        R = (x**2 + y**2)**(1/2)
        phi = atan2(y,x)
        for i in range(k):
            phin = phi + 2*pi*i/k
            xn = d + R * cos(phin)
            yn = d + R * sin(phin)
            canvas.create_oval(xn-r, yn-r, xn+r, yn+r, fill="black")
    for (u,v,volt) in arcs:
        (xu,yu) = vrts[u]
        (xv,yv) = vrts[v]
        ru = (xu**2 + yu**2)**(1/2)
        phiu = atan2(yu,xu)
        rv = (xv**2 + yv**2)**(1/2)
        phiv = atan2(yv,xv)
        for i in range(k):
            phiun = phiu + 2*pi*i/k
            xun = d +ru * cos(phiun)
            yun = d + ru * sin(phiun)
            phivn = phiv + 2*pi*(i+ volt)/k
            xvn = d +rv * cos(phivn)
            yvn = d + rv * sin(phivn)
            canvas.create_line(xvn,yvn,xun,yun,fill="black")
    print("kaj")
#    canvas.create_line(10, 50, 150, 170, 250, 100, fill='blue', width=4, smooth=True)
    window.mainloop()


def risanje(grph,r = 2):
    window = Tk()
    canvas = Canvas(window, width=800, height=500)
    canvas.pack()
    (vrts,adjs) = grph
    for v in vrts.keys():
        (x,y) = vrts[v]
        canvas.create_oval(x-r, y-r, x+r, y+r, fill="black")
    for v in vrts.keys():
        (xv,yv) = vrts[v]
        for u in adjs[v]:
            (xu,yu) = vrts[u]
            canvas.create_line(xv,yv,xu,yu,fill="black")
            
#    canvas.create_line(10, 50, 150, 170, 250, 100, fill='blue', width=4, smooth=True)
    window.mainloop()



def kmn(m=3,n=3):
    vrts = {}
    for i in range(m):
        vrts["u"+str(i)] = (100*i + 100,200)
    for j in range(n):
        vrts["v"+str(j)] = (100*j + 100,400)
    adjs = {}
    for i in range(m):
        u = "u"+str(i)
        for j in range(n):
            v = "v"+str(j)
            sv = (adjs.get(v,[]))
            sv.append(u)
            adjs[v] = sv
            su = (adjs.get(u,[]))
            su.append(v)
            adjs[u] = su
    return (vrts,adjs)

def kn(n=5,r = 100):
    vrts={}
    for i in range(n):
        vrts["v"+str(i)] = (2*r + r*cos(2*pi*i/n),2*r +r*sin(2*pi*i/n))
    adjs = {}
    for i in range(n):
        u = "v"+str(i)
        for j in range(n):
            v = "v"+str(j)
            sv = (adjs.get(v,[]))
            sv.append(u)
            adjs[v] = sv
            su = (adjs.get(u,[]))
            su.append(v)
            adjs[u] = su
    return (vrts,adjs)
    
        
def newcoords(graph):
    (vrts,adjs) = graph
    newvrts = {}
    for v in vrts.keys():
        vfx=vfy=0
        (vx,vy) = vrts[v]
        for u in vrts.keys():
            if u == v:
                continue
            (ux,uy) = vrts[u]
            rsq = (vx-ux)*(vx-ux) + (vy - uy)*(vy - uy)
            vfx += 200*(vx-ux)/rsq
            vfy += 200*(vy-uy)/rsq
            if u in adjs[v]:
                vfx += 0.06*(ux-vx)
                vfy += 0.06*(ux-vx)
        newvrts[v] = (vx + vfx*0.85,vy + vfy*0.85)
    return (newvrts,adjs)
            
# K4
vrts = {"a":(100,0)}
arcs = [("a","a",1),("a","a",2)]
d = 300
risikrov(vrts,arcs,d,4)

# K3,3
vrts = {"a":(100,0)}
arcs = [("a","a",1),("a","a",3)]
d = 300
risikrov(vrts,arcs,d,6)

# Generalized Petersen G(n,r)
n = 12
r = 5
vrts = {"a":(100,0),"b":(200,0)}
arcs = [("a","b",0),("a","a",r),("b","b",1)]
d = 300
risikrov(vrts,arcs,d,n)

# Desargues
vrts = {"a":(100,0),"b":(200,0)}
arcs = [("a","b",0),("a","a",3),("b","b",1)]
d = 300
risikrov(vrts,arcs,d,10)

# Heawood
vrts = {"a":(200,-50),"b":(200,50)}
arcs = [("a","b",0),("a","b",-1),("a","b",2)]
d = 300
risikrov(vrts,arcs,d,7)

# Pappus
vp = {"a":(50,0),"b":(100,0),"c":(300,50)}
ap = [("a","b",-1),("a","a",3),("b","c",0),("a","b",1),("c","c",1)]
d = 300
risikrov(vp,ap,d,6)

# Watkins snark
vp = {"a":(50,-10),"b":(100,-10),"c":(150,-10),"d":(200,-20),
      "e":(100,0),"f":(200,0),
      "g":(50,10),"h":(100,10),"i":(150,10),"j":(200,20)}
ap = [("a","b",0),("b","c",0),("c","d",0),("e","f",0),
      ("g","h",0),("h","i",0),("i","j",0),
      ("a","g",0),("b","h",0),("c","i",0),("d","j",0),("a","j",-1),("d","g",-2)]



d = 300

risikrov(vp,ap,d,5)
