# CARDIAC
# 30. maj 2012
# 31. maj 2012

def ime_ukaza(u):
    """ u = '0', '1', ..., '9'  priredimo trimestno mnemoniko."""
    tab = ["INP","LAC","ADD","TAC","SAC","OUT","SAC","SUB","JMP","HLT"]
    return tab[int(u)]

def stanje(t,pom,ps,aku):
    """ t ... teče
pom ... vsebina pomnilnika
ps ... programski števec
aku ... vsebina akumulatorja
"""    
    return (t,pom,ps,aku)

def izpis_stanja(stanje):
    """ Izpišemo trenutno stanje."""
    print("Izpis stanja:")
    (t,pom,ps,aku) = stanje
    print("Program teče: ",t)
    print("Programski števec: ",ps)
    print("Akumulator: ", aku)
    izpisi_pomnilnik(pom)
    

    
def analiza(vsebina):
    """Analiziramo vsebin celice '+uxy' (znak, ukaz, naslov)"""
    vs = "+" + vsebina if len(vsebina) == 3 else vsebina
    znak = vs[0]
    ukaz = vs[1]
    naslov = vs[2:4]
    return (znak,ukaz,naslov)
    

def prazen_pomnilnik():
    """Vrnemo prazni pomnilnik."""
    pom = ["+001"]+["+000" for i in range(98)]+["+800"]
    return pom

def nalozi_program(prog=[]):
    """Vrnemo vsebino pomnilnika. Na začetku je program, sledijo mu
prazne celice."""
    n = len(prog)
    return prog+["+000" for i in range(100-n)]
    

def izpisi_pomnilnik(pom):
    """Izpisemo vsebino pomnilnika."""
    print("Izpis pomnilnika")
    for i in range(10):
        for j in range(10):
            print(pom[10*i+j],end=" ")
        print()
        
def korak(stanje):
    """ novostanje = korak(stanje). Izvedemo en korak računanja."""
    (t,pom,ps,aku) = stanje
    if t: # program teče
        (za,ua,naa) = analiza(aku)
        vsebina = pom[ps]
        (znak,ukaz,nasl) = analiza(vsebina)
        naslov = int(nasl)
        if ukaz == "9":
            # print("stoj!!!!!!!!!!!!!!")
            return(False,pom,ps,aku)
        elif ukaz == "1":
            aku = pom[naslov]
            return(t,pom,ps+1,aku)
        elif ukaz == "2": #prištej
            naku = int(aku)
            dod = int(pom[naslov])
            paku = naku+dod
            if paku > 999:
                paku -= 1000
            if paku < - 999:
                paku += 1000
            zn = "-" if paku < 0 else "+"
            spaku = str(abs(paku))
            if len(spaku) == 3:
                nspaku = spaku
            elif len(spaku) == 2:
                nspaku = "0"+spaku
            else:
                nspaku = "00"+spaku
            return(t,pom,ps+1,nspaku)
        elif ukaz == "3":
            if za == "-": #skočimo na naslov
                ps = naslov
            else:
                ps += 1
            return(1,(pom,ps,aku))
        elif ukaz == "4" or ukaz == "6":
            pom[naslov] = aku
            return(t,pom,ps+1,aku)
        elif ukaz == "5":
            print("Izhod: ", aku)
            return(t,pom,ps+1,aku)
        elif ukaz == "7":
            naku = int(aku)
            dod = int(pom[naslov])
            paku = naku-aku
            if paku > 999:
                paku -= 1000
            if paku < - 999:
                paku += 1000
            zn = "-" if paku < 0 else "+"
            spaku = str(abs(paku))
            if len(spaku) == 3:
                nspaku = spaku
            elif len(spaku) == 2:
                nspaku = "0"+spaku
            else:
                nspaku = "00"+spaku
            return(t,pom,ps+1,zn+nspaku)
        elif ukaz == "8":
            nps = str(ps)
            nps = (2-len(ps))*"0"+nps
            pom[99] = "+8"+nps
            ps = naslov
            return(t,pom,ps,aku)
        elif ukaz == "0":
            pom[naslov] = input("Vpis :")
            return (t,pom,ps+1,aku)
        else:
            return stanje

def izvajaj(stanje,gostobeseden=True):
    """ izvajaj(stanje) izvaja zaporedoma korake,
dokler ne naleti na ukaz HLT."""
    while True:
        if gostobeseden:
            izpis_stanja(stanje)
        nstanje = korak(stanje)
        (t,pom,ps,aku) = nstanje
        if t:
            stanje = nstanje
        else:
            # print("break!!!!!!!!!!")
            break

def nalozi_in_izvedi(prog,gostobeseden=True):
    pom = nalozi_program(prog)
    stanje = (True,pom,0,"+000")
    izvajaj(stanje,gostobeseden)
    
def test():
    vse = input("Vtipkaj vsebino celice: ")
    print("=== analiza ")
    print("vsebina = ",vse)
    (znak, ukaz,naslov) = analiza(vse)
    print("znak = ",znak)
    print("ukaz = ",ukaz)
    print("naslov = ",naslov)
    print("=== izpis_pomnlnika")
    pom = prazen_pomnilnik()
    print("prazen pomnilik: ",pom)
    izpisi_pomnilnik(pom)
    print("=== imena ukazov")
    for i in range(10):
        u = str(i)
        print(u," ",ime_ukaza(u))
    print("=== preskus ukaza")
    vse = input("Vtipkaj ukaz, ki se postavi v celico 00: ")
    nasl = input("Vtipkaj naslov celice : ")
    vseb = input("Vtipkaj vsebino prejsnje celice: ")
    nnasl = int(nasl)
    pom = prazen_pomnilnik()
    pom[0] = vse
    pom[nnasl] = vseb
    ps = 0
    aku = "+000"
    stanje = (True,pom,ps,aku)
    izpis_stanja(stanje)
    nstanje = korak(stanje)
    izpis_stanja(nstanje)
    
    
    

# test()
    
