#
# Prvi pristop k objektnem programiranju.
#

#
# Ustvarimo "prazen" razred, ki mu dajemo vsebino kasneje. 
#
class Oseba:
    pass

#
# Ustvarimo dva primerka (objekta) tega razreda.
#
janez = Oseba()
peter = Oseba()
#
# Oseba dobi svoje ime.
#
janez.ime = "Janez"
peter.ime = "Peter"
#
# Ustvarjene osebe nanizamo v seznam.
#
os = [janez,peter]
#
# Razredu Oseba priredimo spremenljivko stevilo, ki bo beležila
# število ustvarjenih oseb.
#
Oseba.stevilo = 0
for oseba in os:
    print(oseba.ime)
    Oseba.stevilo += 1
#
# Ustvarimo tretjo osebo in ažuriramo naš model.
#
jana = Oseba()
jana.ime = "Jana"
os.append(jana)
Oseba.stevilo += 1
#
# Vsem osebam dodamo novi lastnosti: priimek in spol. Vsem osebam v sistemu 
# priredimo isti priimek. Izpišemo trenutne podatke o osebah.
#
for oseba in os:
    oseba.priimek = "Novak"
    oseba.spol = "M"
    print(oseba.ime, oseba.priimek)
jana.spol = "Ž" # Popravimo spol na "Ž".
#
# Osebam dodamo še biološkega očeta in mamo.
#
for oseba in os:
    oseba.oce = None
    oseba.mama = None
#
# Naj bo janez oče od jane.
#
jana.oce=janez # To je kazalec!!!!

#
# Drugi pristop k razredom in objektom.
#=

class NovaOseba:

    def __init__(self,ime="",priimek="",oce=None,mama=None,spol="M"):
        self.ime=ime
        self.priimek = priimek
        self.oce = None
        self.mama = None
        self.spol = "M"

    def __repr__(self):
        return str(self.ime)+str(self.priimek)+repr(self.oce)+repr(self.mama)+repr(self.spol)

    def popravi(self,ime="",priimek="",oce=None,mama=None,spol="M"):
        self.ime=ime
        self.priimek = priimek
        self.oce = None
        self.mama = None
        self.spol = "M"

