# Podatki za sudoku
ime = "Grid 01"

kvadrat = "003020600900305001\
001806400\
008102900\
700000008\
006708200\
002609500\
800203009\
005010300"

# Izpisi, statistike za kvadrat
def izpisi(kvadrat):
    """ Izpis kvadrata za sudoku. """
    for i,z in enumerate(kvadrat):
        if i >  0 and i%3==0:
            print("|", end=" ")
        if i == 27 or i == 2*27:
            print("\n",23*"-",end="")
        if i%9==0:
            print()
            print("|",end=" ")
        print(z,end=" ")
    print("|")

def info(sez):
    """Izpis informacije o seznamu sez."""
    print("dolžina:",len(sez))
    print("seznam:", sez)
    if len(sez) != 9:
        print("napaka v dolžini")
    n0 = sez.count(0)
    if n0 == 0:
        print("prazen seznam")
    if n0 == 9:
        print("poln seznam")
    print("Štev. praznih polj:",n0)
    p = 9 - n0
    if n0 > 0:
        p += 1
    mn = set(sez)
    if len(mn) != p:
        print("nedopusten seznam")
    return mn-{0}

def infopolje(kvadrat,k):
    """Izpis informacije za polje z linearnim indeksom k v kvadratu kvadrat."""
    print("sudoku")
    izpis(kvadrat)
    print("linearni indeks:",k)
    print("indeks vrstice :",vrsta(k))
    print("indeks stolpca :",stolpec(k))
    print("indeks kvadratka :",k33(k))
    e = int(kvadrat[k])
    if e == 0:
        print("prazno polje")
    print("Vrednost polja:", e)
    

# vrst, stolpec, kvadratek, ki pripada danemu linearnemu indeksu.
        
def vrsta(k):
    """Indeks vrste v linearnem sudoku 9 x 9"""
    return k//9

def stolpec(k):
    """Indeks stolpca v linearnem sudoku 9 x 9"""
    return k%9

def k33(k):
    """Za indeks k linearnega sudoku 9 x 9 določimo linearni indeks pripadajočega
3 x 3 kvadrata."""
    v = vrsta(k)
    s = stolpec(k)
    v3 = v//3
    s3 = s//3
    return 3*v3 + s3

# sezam indeksov za dano vrsto, stolpec ali kvadratek

def isv(v):
    """ Seznam indeksov vrstice v (0 <= v <= 8).""" 
    sez = []
    for s in range(9):
        e = lindeks(v,s)
        sez.append(e)
    return sez

def iss(s):
    """ Seznam ideksov stolpca s (0 <= s <= 8).""" 
    sez = []
    for v in range(9):
        e = lindeks(v,s)
        sez.append(e)
    return sez

def isk33(k):
    """ Seznam indeksov kvadrata k3 (0 <= k3 <= 8).""" 
    k3 = k
    v3 = k3//3
    s3 = k3%3
    sez = []
    for v in range(3):
        for s in range(3):
            vv = 3*v3 + v
            ss = 3*s3 + s
            k = lindeks(vv,ss)
            sez.append(k)
    return sez

# Obrat, iz koordinat linearni indeks, oz. element

def lindeks(v,s):
    """Vrednost elemementa v sudoku 9 x 9 (v indeks vrste, s indeks stolpca."""
    k = 9*v + s
    return k


def element(kvadrat,v,s):
    """Vrednost elemementa v sudoku 9 x 9 (v indeks vrste, s indeks stolpca."""
    k = lindeks(v,s)
    return int(kvadrat[k])

# seznam elementov naračunan iz seznama indekov.

def elti(kvadrat,sez):
    """ Seznam elementov kvadrata kvadrat, ki imajo linearne indekse
iz seznama sez."""
    el = []
    for s in sez:
        el.append(int(kvadrat[s]))
    return el

# sezam elementov za dano vrsto, stolpec ali kvadratek

def sv(kvadrat,v):
    """ Seznam vrednosti(?) vrstice v (0 <= v <= 8)."""
    return elti(kvadrat,isv(v))

def ss(kvadrat,s):
    """ Seznam vrednosti(?) stolpca s (0 <= s <= 8).""" 
    return elti(kvadrat,iss(s))

def sk33(kvadrat,k):
    """ Seznam vrednosti(?) kvadrata k3 (0 <= k3 <= 8).""" 
    return elti(kvadrat,isk33(k))

        
def prosti(kvadrat,k):
    """ Seznam prostih (dopustnih) vrednosti za linearno polje k."""
    li = sk33(kvadrat,k33(k))
    li.extend(ss(kvadrat,stolpec(k)))
    li.extend(sv(kvadrat,vrsta(k)))
    sli = set(li)
    psli = set([int(x) for x in sli])
    u = set(range(1,10))
    v = u.difference(psli)
    return v

def najboljsi(kvadrat):
    izpisi(kvadrat)
    for k,e in enumerate(kvadrat):
        print(k,e)
        if int(e) == 0:
            print(k,prosti(kvadrat,k))
            
def naj(kvadrat):
    for k,e in enumerate(kvadrat):
        if int(e) == 0:
            yield k
            


            
        
        
