class Node:
    def __init__(self,name="Vozlisce",x=0,y=0):
        self.name= name
        self.x = x
        self.y = y
        
    def __repr__(self):
        return self.name+"("+repr(self.x)+","+repr(self.y)+")"

class Arc:
    def __init__(self,init= None,reverse= None):
        self.init = init
        self.reverse = reverse

    def __repr__(self):
        return "("+self.init.name+"->"+self.reverse.init.name+")"

class Graph:
    def __init__(self,name="Graph",vertexset=[],arcset=[]):
        self.vertexset=vertexset
        self.arcset=arcset
        self.name=name
    def __repr__(self):
        r = self.name
        for v in self.vertexset:
            r += repr(v)
        for a in self.arcset:
            r += repr(a)
        return r

def K(n):
    r = range(n)
    vs = []
    for v in r:
        vt = Node(str(v))
        vs.append(vt)
    arcs = []
    for u in vs:
        for v in vs:
            if u != v:
                uv = Arc(u)
                vu = Arc(v)
                uv.reverse=vu
                vu.reverse=uv
                arcs.append(uv)
                arcs.append(vu)
    cg = Graph("K("+str(n)+")",vs,arcs)
    return cg
                
    
