from tkinter import *
from math import *

def graf(f, a, b):
    w = 600
    h = 400
    window = Tk()
    canvas = Canvas(window, width=w, height=h)
    canvas.pack()

    xmin = 10
    xmax = w - 10
    k = (xmax - xmin) / (b - a)
    n = (b * xmin - a * xmax) / (b - a)
    x0 = n
    y0 = h / 2

    s = []
    x = a
    while x <= b:
        s.append((k * x + n, y0 - k * f(x)))
        x += 1 / k

    canvas.create_line(0, y0, w, y0, arrow=BOTH)
    canvas.create_line(x0, 0, x0, h, arrow=FIRST)
    canvas.create_line(x0 + k, y0 - 5, x0 + k, y0 + 5)
    canvas.create_line(x0 - 5, y0 - k, x0 + 5, y0 - k)
    canvas.create_text(x0 - 7, y0 - k, text='i', anchor=E)
    canvas.create_text(x0 + k, y0 + 7, text='1', anchor=N)
    canvas.create_line(s, fill='red')
    window.mainloop()

#graf(sin, -2*pi, 2*pi)
# graf(exp, -10, 2)
# graf(tan, -5, 5)
graf(lambda x: sin(10 * x + 2), -2 * pi, pi)
