from kivy.app import App
from kivy.uix.widget import Widget
from kivy.graphics import Rectangle

from kivy.core.window import Window
import urllib2
import json
import math

from threading import Event

from mythread import MyThread
from myserver import MyServer

class BarMap(Widget):
	
	#COS of drawing must matches the COS of map graphic!
	
	#POSITION OF WHERE THE BarMap ON WIDGET
	screenXoffset=0 #offsetx 
	screenYoffset=0
	
	#SIZE OF THE WIDHET WHERE THE BarMap SHOULD FIT
	widgetWidth=-1 
	widgetHeight=-1
	
	#SIZE OF THE BarMap the scripts fits the map to maximal width of the widget
	screenWidth=0
	screenHeight=0
	
	#THRASHOLD FOR TABLE CLICK EVENT
	trashold=20
	
	#OTHER
	myMainWidget=-1
	tables=[]
	
	#THREADING
	stopFlag=-1
	poolThread=-1
	disabled=False
	
	def __init__(self, myMainWidget, widgetWidth, widgetHeight, offset_x=-1, offset_y=-1):
		print '__inti__ BarMap'
		super(BarMap, self).__init__()
		self.myMainWidget=myMainWidget
		self.widgetWidth=widgetWidth
		self.widgetHeight=widgetHeight
		self.screenYoffset=offset_y;
		self.screenXoffset=offset_x;
		
		#POOLTABLES FOR DATA SYNCHRONIUSLY
		self.tables=MyServer.poolTables(self.myMainWidget.barId)
		self.drawMap()
	
	def start(self):
		self.stopFlag = Event()
		self.poolThread = MyThread(self.stopFlag,self.refresh)
		self.poolThread.refreshRate=4.0
		self.poolThread.start()
		
	
	def clean(self):
		if self.stopFlag!=-1:
			self.stopFlag.set();
		
	def on_touch_up(self, touch):
		if self.disabled==False:
			# DETECT WHICH TABLE CLIKCED: LOOP THROUHJ ALL TABLES
			for i in range(0,len(self.tables)):
				scale=self.screenWidth/float(self.tables[i]['map_width'])
				x1=float(self.tables[i]['x_location'])*scale+self.screenXoffset
				y1=float(self.tables[i]['y_location'])*scale+self.screenYoffset
				
				dist = math.hypot(touch.x - x1, touch.y - y1)
				if dist<self.trashold:
					self.myMainWidget.selectGame(self.tables[i]['id'])
					print 'Selected table id: '+self.tables[i]['id']
					break

	def drawMap(self): #Draw map in center of the screen
		with self.canvas:
			self.screenHeight=self.widgetWidth*9/16
			self.screenWidth=self.widgetWidth
			
			if(self.screenXoffset==-1):
				self.screenXoffset=0
			
			if(self.screenYoffset==-1):
				self.screenYoffset=(self.widgetHeight-self.screenHeight)/2
			Rectangle(source='data/republika-palma-del-popo.jpg', pos=(self.screenXoffset, self.screenYoffset)
				  , size=(self.screenWidth, self.screenHeight))
			#upgrade this to load image from URL http://www.studenti.famnit.upr.si/~famnit.student/persuasive/img/1.jpg
	
	def refresh(self):
		print 'myBarMap: refresh tables'
		self.tables=MyServer.poolTables(self.myMainWidget.barId)
		self.drawMap()
