#UTILS IMPORTS
import sys
from kivy.app import App
from kivy.utils import *
from kivy.core.window import Window
from kivy.clock import Clock
from threading import Event
from functools import partial

#UI IMPORTS
from kivy.uix.widget import Widget
from kivy.uix.button import Button
from kivy.uix.popup import Popup
from kivy.uix.label import Label
from kivy.uix.gridlayout import GridLayout
from kivy.uix.boxlayout import BoxLayout
from kivy.uix.screenmanager import ScreenManager, Screen

#MY IMPORTS
from chat import MyChat
from barmap import BarMap
from mythread import MyThread
from myserver import MyServer

def callbackBack(instance):
	global sm
	global myMainWidget
	myMainWidget.clean() #stop all threads
	myMainWidget.start() #start all threads for mainWidgetView
		
	sm.transition.direction='left'
	sm.current='Home'
			
class MyMainWidget(Widget):
	
	#TABLE PROPERTIES
	barId=1
	tableId=sys.argv[1]
	status='AVAILABLE'
	popup=-1
	
	#GAME OBJECTS
	myChat=-1
	myBarMap=-1
	
	#hack for sharing varibales acreoss threads
	inviteMsg=-1
	
	#THREADING
	stopFlag=-1
	poolThread=-1
	
	def __init__(self):
		super(MyMainWidget, self).__init__()
		global myMainWidget
		myMainWidget=self
		self.myBarMap=BarMap(self, Window.size[0],Window.size[1],-1, -1)
		self.add_widget(self.myBarMap)
		self.start()
	
	def clean(self): #stop all pooling threads
		global myMainWidget
		if self.myChat!=-1:
			self.myChat.clean()
		if self.myBarMap!=-1:
			self.myBarMap.clean()
		if self.stopFlag!=-1:
			self.stopFlag.set()
		
		myMainWidget.status='AVAILABLE'
		MyServer.setTableStatus(myMainWidget.tableId, 'AVAILABLE')
	
	def start(self):
		self.stopFlag = Event()
		self.poolThread = MyThread(self.stopFlag,self.refresh)
		self.poolThread.start()
		self.myBarMap.start()
		
	def refresh(self): #pool invites and react
		print "myMainWidget: refresh invites"
		msgs=MyServer.getTableInvites('PENDING',self.tableId, 'INVITE') #pool table messages
			
		if(self.status=='AVAILABLE'):
			print msgs
			#look through all invite mesages
			if len(msgs)!=0:
				# FUTURE mark messages that could not be porcessed asREJECTED
				self.inviteMsg=msgs[0]
				self.status='BUSY'
				MyServer.setTableStatus(self.tableId, 'BUSY')
				Clock.schedule_once(self.open_invite_popup) #you can not call UI thread from another thread directly, hence Clock is used 
		else: #we are busy so decline all invits
			for i in range(0,len(msgs)):
				print msgs[i]
				MyServer.sendMsg( 'DECLINE', '', -1, msgs[i]['r_table_id'], msgs[i]['s_table_id'],
						 msgs[i]['session_id'], msgs[i]['application_id'], -1)
		
	def acceptButtonClicked(self, n2):
		global myMainWidget
		print myMainWidget.inviteMsg
		MyServer.setTableStatus(myMainWidget.tableId, 'BUSY')
		myMainWidget.status='BUSY'
		
		if(myMainWidget.inviteMsg['application_id']=='1'):
			myMainWidget.startChat(myMainWidget.inviteMsg['s_table_id'], myMainWidget.inviteMsg['session_id']) #s_table_id is used beacuse in this case the sender becomes the reciever in conversation
		else:
			print 'start some other game'
		myMainWidget.popup.dismiss()
	
	def declineButtonClicked(self, n2):
		global myMainWidget
		myMainWidget.popup.dismiss()
		myMainWidget.status='AVAILABLE'
		MyServer.setTableStatus(myMainWidget.inviteMsg['r_table_id'], 'AVAILABLE')
		MyServer.sendMsg( 'DECLINE', '', -1, myMainWidget.inviteMsg['r_table_id'], myMainWidget.inviteMsg['s_table_id'], myMainWidget.inviteMsg['session_id'], myMainWidget.inviteMsg['application_id'], -1)
				
	def open_invite_popup(n1, n2):
		#UI PROMPT
		acceptButton = Button(text='Accept')
		declineButton = Button(text='Decline')
		gl=GridLayout()
		gl.rows=2
		gl.add_widget(Label(text='Table '+str(myMainWidget.inviteMsg['s_table_id'])+ ' invites you to play chat')) #CHAT is hardcoded at the moment.
		bl=BoxLayout()
		bl.add_widget(acceptButton)
		bl.add_widget(declineButton)
		gl.add_widget(bl)
		myMainWidget.popup = Popup(content=gl, auto_dismiss=False, size_hint=(None, None), size=(400, 400), title= 'Game invite')
		myMainWidget.popup.open()
		
		#CALLBACK FUNCTIONS 
		acceptButton.bind(on_press=myMainWidget.acceptButtonClicked)
		declineButton.bind(on_press=myMainWidget.declineButtonClicked)
				
	
	#CHAT SPECIFIC
	def startChat (self, rTableId, sessionId):
		global myMainWidget
		
		myMainWidget.status=='BUSY'
		self.clean() #stop all current threads
		
		print 'startChat'
		if sm.has_screen(name='Chat'):
			sm.remove_widget(sm.get_screen(name='Chat'))
		screenHome = Screen(name='Chat')
		self.myChat=MyChat(myMainWidget, rTableId, sessionId)
		screenHome.add_widget(myMainWidget.myChat)
					
		button_back = Button(text='Back', font_size='14sp', size_hint=(None, None), size=('70sp', '40sp'))
		button_back.bind(on_press=callbackBack)
		
		sm.add_widget(screenHome)
		screenHome.add_widget(button_back)
		sm.current="Chat"
		sm.transition.direction='right'
		self.popup.dismiss()
		self.myChat.start()
		#open new screen with chat applicaiton resides in another file
	
	def selectGame(self, rTableId):
				
		#BUILD UI
		gameBoard=GridLayout()
		gameBoard.cols=2
		gameBoard.rows=2
		
		gameBoard.padding=[20, 20, 20, 20]
		gameBoard.spacing=[20, 20]
		
		button1 = Button(text='CHAT')
		button2 = Button(text='HANG MAN')
		button3 = Button(text='DRAW')
		button4 = Button(text='BILD')
		
		gameBoard.add_widget(button1)
		gameBoard.add_widget(button2)
		gameBoard.add_widget(button3)
		gameBoard.add_widget(button4)
		
		self.popup = Popup(title='Select Game', content=gameBoard, size_hint=(None, None), size=(400, 400))
		button1.bind(on_press= lambda x: self.startChat(rTableId,-1))
		self.popup.open()
	
#GLOBALS
sm = ScreenManager()
myMainWidget= MyMainWidget()

class MyPersuasiveApp(App):
	global MyMainWidget
	
	def build(self):
		screenHome = Screen(name='Home')
		screenHome.add_widget(myMainWidget)
		sm.add_widget(screenHome)
		return sm;
	
	def on_stop(self):
		myMainWidget.clean()

if __name__ == '__main__':
	MyPersuasiveApp().run()
