from kivy.app import App
from kivy.uix.widget import Widget
from kivy.graphics import Color, Ellipse, Line
from kivy.uix.button import Button
from random import random
from kivy.utils import *
from kivy.uix.slider import *
from kivy.uix.textinput import TextInput
from barmap import BarMap
from kivy.core.window import Window

from kivy.uix.gridlayout import GridLayout
from kivy.uix.boxlayout import BoxLayout
import urllib2
import urllib
import json

from threading import Event
from mythread import MyThread
from myserver import MyServer

class MyChat(GridLayout):
	
	#COM PROTOCOL
	rTableId=-1
	applicationId=1 #chat application id is 1
	sessionId=-1
	myMainWidget=-1
	
	#UI
	textThread=-1
	textInput=-1
	
	#Threading
	poolThread=-1
	stopFlag=-1
	
	def __init__(self, myMainWidget,rTableId, sessionId):
		super(MyChat, self).__init__()
		
		self.myMainWidget=myMainWidget
		self.rTableId=rTableId
		print "MyChatInvite table: "+str(rTableId)
		
		#build UI for sending messahes
		self.textThread = TextInput(text='', multuline=True)
		self.textThread.disabled=True;
		self.textInput = TextInput(text='Text to send', multuline=False)
		sendButton = Button(text='Send', font_size='14sp', pos=('210sp', 0), size=('70sp', '40sp'))
		
		self.cols=2
		boxLayout=BoxLayout(orientation='vertical')
		boxLayout.add_widget(self.textThread)
		boxLayout.add_widget(self.textInput)
		
		barMap=BarMap(self.myMainWidget, float(Window.size[0])/2,float(Window.size[1])/2, 0, 0)
		barMap.disabled=True;
		sendButton.bind(on_press=lambda x: self.sendButtonClicked(text=self.textInput.text))
	
		self.add_widget(boxLayout)
		self.add_widget(sendButton)
		self.add_widget(barMap)
		
		#COM PROTOCOL
		if(sessionId==-1):	#if session id not set create new session else join existing session
			#start session
			self.sessionId=MyServer.startSession(self.myMainWidget.tableId, self.rTableId)
			print 'Session id: '+str(self.sessionId)
			#send application invite
			MyServer.sendMsg( 'INVITE', 'Chat?', -1, self.myMainWidget.tableId, self.rTableId, self.sessionId, self.applicationId, -1)
			self.textThread.text='You: Invitation to table '+str(self.rTableId)+' sent.'
		else:	
			self.sessionId=sessionId
			#send invite accepted
			self.msgInviteId=MyServer.sendMsg( 'TEXT', 'Invitation accepted.', -1, self.myMainWidget.tableId, self.rTableId, self.sessionId, self.applicationId, -1)
			print 'Msg Accept Invite Sent'
			self.textThread.text='You: Table '+str(self.rTableId)+' invitation accepted.'
		
	def sendButtonClicked(self, text):
		MyServer.sendMsg( 'TEXT', text, -1, self.myMainWidget.tableId, self.rTableId, self.sessionId, self.applicationId, -1)
		self.textInput.text='';
		self.textThread.text+="\n You: "+text
	
	def clean(self): #stop all myChat threads
		MyServer.sendMsg( 'DECLINE', '', -1, self.myMainWidget.tableId, self.rTableId, self.sessionId, self.applicationId, -1)
		if self.stopFlag!=-1:
			self.stopFlag.set()
		self.sessionId=-1

	def start(self): #stop all myChat threads
		self.stopFlag = Event()
		self.poolThread = MyThread(self.stopFlag,self.refresh)
		self.poolThread.start()	

	def refresh(self):
		print "myChat: refresh messages"
		msgs=MyServer.getTableMsgs('PENDING',self.myMainWidget.tableId, self.sessionId) #pool table messages
		
		#look through all mesages
		for i in range(0,len(msgs)):
			if msgs[i]['type']=="TEXT":
				#self.textInput.text='';
				self.textThread.text+="\n Budy: "+msgs[i]['msg']
				print 'New Mesage: '+ msgs[i]['msg']
			elif msgs[i]['type']=="DECLINE":
				self.textThread.text+="\n Budy: Busy or left chat."

