class Professor < ActiveRecord::Base

	validates :first_name, :last_name, :faculty, presence: true

	has_many :reviews

	def average_rating
		if reviews.count > 0
			(reviews.map{ |review| review.rating }.sum.to_f / reviews.count).round(2)
		else
			0
		end
	end

	def has_review?
		reviews.count > 0
	end

end
