desc "Fetch FMF professors"
task :fetch_fmf_professors=> [:environment] do |t, args|
  require 'nokogiri'
  require 'open-uri'
  require 'rake'
  require "benchmark"
 
  time = Benchmark.realtime do

    Professor.destroy_all

    base_url = "http://www.fmf.uni-lj.si/si/imenik/oddelek/"

    [2717, 2718].each do |id|
      url = base_url + id.to_s
      doc = Nokogiri::HTML(open(url))
      
      doc.search('table.directory-list tr').each do |row|
        cells = row.search('td')
        position = cells.first.text
        full_name_arr = cells.last.at_css('b a').text.split ' '
        
        Professor.create! first_name: full_name_arr.last, last_name:  full_name_arr[0..-2].join(" "), position: position, faculty: 'Faklteta za matematiko in fiziko'
      end
    end
  end
  puts "Time elapsed: #{time} seconds"
end