class Professor < ActiveRecord::Base

	validates :first_name, :last_name, :faculty, presence: true

	has_many :reviews

	def full_name
		"#{first_name} #{last_name}"
	end

	def average_rating
		reviews.count == 0 ? "Unrated" : (reviews.map(&:rating).sum.to_f / reviews.count).round(2)
	end

	def self.top n = 5
		self.sorted_by_average_rating.reverse[0..(n-1)]
	end

	def self.worst n = 5
		self.sorted_by_average_rating[0..(n-1)]
	end

	private

		def self.sorted_by_average_rating
			Professor.all.reject{ |p| p.average_rating == 'Unrated' }.sort_by{ |p| p.average_rating }
		end

end
