class Review < ActiveRecord::Base
	validates :rating, 
		presence: true, 
		numericality: { only_integer: true, less_than: 6, greater_than: 0 }
	validates :professor_id, presence: true

	belongs_to :professor
	belongs_to :user

	def username
		user.try(:nickname) || 'Anonymous'
	end
end

