desc "Fetch FMF professors"
task :fetch_fmf_professors=> [:environment] do |t, args|
  require 'nokogiri'
  require 'open-uri'
  require "benchmark"
 
  time = Benchmark.realtime do
    Professor.destroy_all
    [2717, 2718].each do |id|
      Nokogiri::HTML(open("http://www.fmf.uni-lj.si/si/imenik/oddelek/#{id.to_s}")).search('table.directory-list tr').each do |row|
        cells = row.search('td')
        full_name_arr = cells.last.at_css('b a').text.split ' '
        Professor.create! first_name: full_name_arr.last, last_name:  full_name_arr[0..-2].join(" "), position: cells.first.text, faculty: 'Faklteta za matematiko in fiziko'
      end
    end
  end
  puts "Time elapsed: #{time} seconds"
end