class Ability
  include CanCan::Ability

  def initialize user
    user ||= User.new # guest user (not logged in)
    if user.is_admin?
      can :manage, :all
    else
      can :read, Professor
      can [:read, :create], Review
      can [:show, :create], User

      can [:update], User do |u|
        u == user
      end

      # is logged in but maybe doesnot have a role
      if user.email.present?
        can [:create, :update], Professor
        can :update, Review do |r|
          r.try(:user) == user || user.is_moderator?
        end
      end

      if user.is_moderator?
        can :destroy, Review
      end
    end    
  end
end
